// Driver Init module
#include "app.h"

int bDrvOkay=0; // 1 if the Driver has been initted okay, and it's okay to use the BurnDrv functions

char szAppRomPath[256]="D:\\roms\\";
extern "C" int dprintf(char *format, ...);
extern void DisplayErrorMessage(char* msg);
extern void* osd_malloc(int n);

static int DoLibInit() // Do Init of Burn library driver
{
  int i=0; int nRet=0;
  static char *szRomName[BZIP_MAX];

  memset(&szRomName,0,sizeof(szRomName));
  for (i=0;i<BZIP_MAX;i++)
  {
    char *szName=NULL; int nRet=0; int nStrLen=0;

    nRet=BurnDrvGetZipName(&szName,i);
    if (nRet!=0) break;

    // Allocate space for each full pathname
    nStrLen=strlen(szName)+strlen(szAppRomPath);
    szRomName[i]=(char *)osd_malloc(nStrLen+1); if (szRomName[i]==NULL) continue;
    sprintf (szRomName[i],"%s%s",szAppRomPath,szName); // Use path plus default zip file name
    // Point bzip to it
    szBzipName[i]=szRomName[i];
  }
  szBzipName[i]=NULL; // Mark end of zip name list

  // Open the zip file(s) and check if they are okay
  BzipOpen();

  dprintf("BurnDrvInit Start\n");
  nRet=BurnDrvInit(); // Init the driver
  dprintf("BurnDrvInit End\n");

  BzipClose();
	
   if (nBzipError!=0)
  {
    // Make the correct title and icon
    if (nBzipError&1) { 
		return 1;
	}
  }

  for (i=0;i<BZIP_MAX;i++)
  {
    // Free the names of each pathnames
    if (szRomName[i]!=NULL) free(szRomName[i]); // Free the strings
    szRomName[i]=NULL; szBzipName[i]=NULL; // Blank BZip list
  }
  szBzipName[i]=NULL; // Mark end of zip name list

  if (nRet!=0) return 1;
	
  return 0;
}

int DrvInit(int nDrvNum)
{
  int nRet=0;
  DrvExit(); // Make sure exited
  
  nBurnDrvSelect=nDrvNum; // set the driver number
  nRet=DoLibInit(); // Init the Burn library's driver

  if (nRet!=0)
  {
	dprintf("nRet!=0\n");
	DisplayErrorMessage("ROM Error - Press A to continue");
    BurnDrvExit(); // Exit the driver
    return 1;
  }

  dprintf("GameInpInit\n");
  GameInpInit(); // Init game input
  // Load config for the game
  nRet=ConfigGameLoad(); if (nRet!=0) ConfigGameSave(); // create initial game config file

  dprintf("GameInpDefault\n");
  // Dip switch values in driver will have been set now:
  GameInpDefault(); // Auto-config any input which is still undefined to defaults
  // (also sets/gets dip switch valeus from driver)

  bDrvOkay=1; // Okay to use the BurnDrv functions
  nBurnLayer=0xff; // show all layers
  // Init the video plugin
  dprintf("VidInit\n");
  nRet=VidInit();
  if (nRet!=0) { dprintf("nRet!=0\n"); return 1; }
  // Reset the speed throttling code, so we don't 'jump' after the load
  dprintf("RunReset\n");
  RunReset();

  return 0;
}

int DrvExit()
{
  if (nBurnDrvSelect<nBurnDrvCount)
  {
    // Save config for the game
    if (bDrvOkay) ConfigGameSave(); // Only save config if we initted okay
    GameInpExit(); // Exit game input
    BurnDrvExit(); // Exit the driver
  }

  bDrvOkay=0; // Stop using the BurnDrv functions

  bRunPause=0; // Don't pause when exited

  if (bDSoundOkay)
  {
    // Write silence into the sound buffer on exit, and for drivers which don't use pBurnSoundOut
    memset(DSoundNextSound,0,nDSoundSegLen<<2);
  }

  nBurnDrvSelect=~0U; // no driver selected
  return 0;
}
